package gov.va.vamf.scheduling.direct.domain;

import com.agilex.healthcare.veteranappointment.domain.Namespace;
import org.springframework.data.mongodb.core.mapping.Document;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import java.util.Optional;

@Document
@XmlAccessorType(value = XmlAccessType.NONE)
@XmlRootElement(namespace = Namespace.DirectScheduling)
public class RequestEligibilityCriteria extends DomainBaseObject {

    @XmlElement
    private CoreSettings requestSettings;

    @XmlElement
    private CustomRequestSettings customRequestSettings;


    public CoreSettings getRequestSettings() {
        return requestSettings;
    }

    public void setRequestSettings(CoreSettings requestSettings) {
        this.requestSettings = requestSettings;
    }

    public CustomRequestSettings getCustomRequestSettings() {
        return customRequestSettings;
    }

    public void setCustomRequestSettings(CustomRequestSettings customRequestSettings) {
        this.customRequestSettings = customRequestSettings;
    }


    /**
     * Searches requestSettings and customRequestSettings by id
     * @param settingId
     * @param <T>
     * @return the setting matching the given id
     */
    @SuppressWarnings("unchecked")
    public <T extends CoreSetting> Optional<T> getSetting(final String settingId) {
        Optional<? extends CoreSetting> setting = Optional.empty();

        if (customRequestSettings != null) {
            setting = customRequestSettings.findCustomRequestSettingById(settingId);
        }

        if (!setting.isPresent() && requestSettings != null) {
            setting = requestSettings.findCoreSettingById(settingId);
        }

        return (Optional<T>)setting;
    }
}
